﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Chapitre_11_5
{
    public class Chapitre11_5 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Map map;
        Tile heros;
        Rectangle camera;

        NetworkSession session;
        AvailableNetworkSessionCollection availableSessions;
        Dictionary<string, Tile> otherPlayers;
        PacketReader packetReader;
        PacketWriter packetWriter;

        public Chapitre11_5()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            ServiceHelper.Game = this;
            Components.Add(new KeyboardService(this));
            Components.Add(new GamePadService(this));
            Components.Add(new GamerServicesComponent(this));
            graphics.PreferredBackBufferWidth = 160;
            graphics.PreferredBackBufferHeight = 160;
        }

        protected override void Initialize()
        {
            map = new Map(new byte[,] { {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
                                      , {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 1, 0, 0, 0, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 1, 0, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 1, 1, 0, 1, 0}
                                      , {0, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 1, 0}
                                      , {0, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 0, 0, 3, 3, 0, 0, 0, 0, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 3, 3, 3, 3, 3, 0, 0, 0, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 2, 2, 2, 0, 1, 0}
                                      , {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 2, 2, 0, 1, 0}
                                      , {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}
                                      , {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}});

            camera = new Rectangle(0, 0, 5, 5);
            heros = new Tile(2, 2, 4);
            heros.Position = new Vector2(64, 64);

            packetReader = new PacketReader();
            packetWriter = new PacketWriter();

            otherPlayers = new Dictionary<string, Tile>();

            base.Initialize();
        }

        void session_GamerJoined(object sender, GamerJoinedEventArgs e)
        {
            foreach (NetworkGamer networkGamer in session.AllGamers)
            {
                if (networkGamer != session.LocalGamers[0] && otherPlayers.ContainsKey(networkGamer.Gamertag))
                {
                    Tile newTile = new Tile(-1, -1, 5);
                    newTile.LoadContent(Content, "tile");
                    otherPlayers.Add(networkGamer.Gamertag, newTile);
                }
            }
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            foreach (Tile tile in map.TileList)
            {
                tile.LoadContent(Content, "tile");
            }
            heros.LoadContent(Content, "tile");
        }

        protected override void Update(GameTime gameTime)
        {
            if ((Keyboard.GetState().IsKeyDown(Keys.C) || GamePad.GetState(PlayerIndex.One).IsButtonDown(Buttons.A)) && session == null)
            {
                availableSessions = NetworkSession.Find(NetworkSessionType.SystemLink, 2, null);

                if (availableSessions != null && availableSessions.Count > 0)
                    session = NetworkSession.Join(availableSessions[0]);
                else
                    session = NetworkSession.Create(NetworkSessionType.SystemLink, 2, 31);

                session.GamerJoined += new EventHandler<GamerJoinedEventArgs>(session_GamerJoined);
            }
            else
            {
                if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Up) || ServiceHelper.Get<IGamePadService>().ButtonHasBeenPressed(Buttons.LeftThumbstickUp))
                {
                    if (map.TileList[heros.Y - 1, heros.X].Type >= 0)
                    {
                        camera.Y -= 1;
                        heros.Y -= 1;
                        packetWriter.Write(new Vector2(heros.X, heros.Y));
                        session.LocalGamers[0].SendData(packetWriter, SendDataOptions.InOrder);
                    }
                }
                if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Right) || ServiceHelper.Get<IGamePadService>().ButtonHasBeenPressed(Buttons.LeftThumbstickRight))
                {
                    if (map.TileList[heros.Y, heros.X + 1].Type >= 0)
                    {
                        camera.X += 1;
                        heros.X += 1;
                        packetWriter.Write(new Vector2(heros.X, heros.Y));
                        session.LocalGamers[0].SendData(packetWriter, SendDataOptions.InOrder);
                    }
                }
                if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Down) || ServiceHelper.Get<IGamePadService>().ButtonHasBeenPressed(Buttons.LeftThumbstickDown))
                {
                    if (map.TileList[heros.Y + 1, heros.X].Type >= 0)
                    {
                        camera.Y += 1;
                        heros.Y += 1;
                        packetWriter.Write(new Vector2(heros.X, heros.Y));
                        session.LocalGamers[0].SendData(packetWriter, SendDataOptions.InOrder);
                    }
                }
                if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Left) || ServiceHelper.Get<IGamePadService>().ButtonHasBeenPressed(Buttons.LeftThumbstickLeft))
                {
                    if (map.TileList[heros.Y, heros.X - 1].Type >= 0)
                    {
                        camera.X -= 1;
                        heros.X -= 1;
                        packetWriter.Write(new Vector2(heros.X, heros.Y));
                        session.LocalGamers[0].SendData(packetWriter, SendDataOptions.InOrder);
                    }
                }

                if (session != null)
                {
                    session.Update();

                    LocalNetworkGamer gamer = session.LocalGamers[0];
                    if (gamer.IsDataAvailable)
                    {
                        NetworkGamer sender;
                        gamer.ReceiveData(packetReader, out sender);
                        if (gamer != sender)
                        {
                            Vector2 temp = packetReader.ReadVector2();
                            ((Tile)otherPlayers[gamer.Gamertag]).X = (int)temp.X;
                            ((Tile)otherPlayers[gamer.Gamertag]).Y = (int)temp.Y;
                        }
                    }

                }
            }

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            spriteBatch.Begin();
            if (session == null)
            {
            }
            else
            {
                map.Draw(spriteBatch, camera);
                heros.Draw(spriteBatch);
                foreach (Tile tile in otherPlayers.Values)
                {
                    if (camera.Contains(tile.X, tile.Y))
                    {
                        tile.Position = new Vector2((tile.X - camera.X) * 32, (tile.Y - camera.Y) * 32);
                        tile.Draw(spriteBatch);
                    }
                }
            }
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
